<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class WC_Shipping_Wanderlust_Packnow extends WC_Shipping_Method {

    public $title;
    public $enabled;
    public $email;
    public $redondear;      
    public $password;      
    public $agregar_exta;      
    public $envio_gratis;      
    
    public function __construct($instance_id = 0){

      $this->id = 'wanderlust_packnow';
      $this->instance_id = absint( $instance_id );
      $this->method_title       = __( 'PackNow', 'wanderlust-packnow' );
      $this->method_description   = __( 'Obtener costos de envió de forma dinámica para PackNow.', 'woocommerce' );

      $this->supports  = array(
        'shipping-zones',
        'instance-settings',
      );

      $this->init_form_fields();
      $this->init_settings();

      $this->enabled	= $this->get_option( 'enabled' );
      $this->title 		= $this->get_option( 'title' );
      $this->email = $this->get_option('email');
      $this->password = $this->get_option('password');
      $this->seguro = $this->get_option('seguro');

      add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
    }

	  public function init_form_fields(){

      $this->instance_form_fields = array(
        'packing'           => array(
          'title'           => __( 'Todos los campos son OBLIGATORIOS', 'wc-packnow' ),
          'type'            => 'title',
          'description'     => __( '
            1- Si tiene alguna duda o consulta, no dude en <a href="https://www.packnow.com.ar/quienes-somos/" target="_blank">contactarnos</a>. 
            </br> 2- Los productos deben tener peso y dimensiones para que Packnow pueda calcular los costos, <a href="https://www.packnow.com.ar/calcula-tu-envio" target="_blank">consulta Aquí</a> 
            </br> 3- Tu envío puede pesar hasta 32 kilos para ser admitido. Las medidas máximas permitidas son hasta 80x80x50 cm, <a href="https://www.packnow.com.ar/calcula-tu-envio" target="_blank">consulta Aquí</a> 
            </br >4- Para operar con nuestro Plugin, debes tener cuenta en nuestra Plataforma. Para crear una CUENTA en PACKNOW <a href="https://app.packnow.com.ar/signup?campaign=woo-pn&campaignId=PN_WOO" target="_blank">CLICK AQUI</a>.       
          
            
            ', 'wc-packnow' ),
          ),
        'enabled' => array(
          'title' 		=> __( 'Activar/Desactivar', 'wc-packnow' ),
          'type' 			=> 'checkbox',
          'label' 		=> __( 'Wanderlust - Pack Now', 'wc-packnow' ),
          'default' 		=> 'yes'
        ),
        'title' => array(
          'title' 		=> __( 'Titulo', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Controla el título que el usuario ve durante el pago.', 'wc-packnow' ),
          'default'		=> __( 'Envío por PackNow', 'wc-packnow' )
        ),
        'email' => array(
          'title' 		=> __( 'Email', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Tu email con Pack Now.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),
        'password' => array(
          'title' 		=> __( 'Password', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Tu password con Pack Now.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),     
        'telefono' => array(
          'title' 		=> __( 'Telefóno', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Corresponde al número telefónico del contacto para el retiro es un número de 10 dígitos como mínimo', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),     
        
        'lastname' => array(
          'title' 		=> __( 'Apellido o Razón Social', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Apellido o Razón Social del remitente', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),     
        'firstname' => array(
          'title' 		=> __( 'Nombre', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Nombre del remitente', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),      
        'fantasyName' => array(     
          'title' 		=> __( 'Nombre de fantasia', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Nombre de fantasia del remitente, es utilizado en la impresión de las etiquetas, si se desea.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ), 
        'location' => array(
          'title' 		=> __( 'Ciudad', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Ciudad de la dirección del remitente.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),     
        'location' => array(
          'title' 		=> __( 'Ciudad', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Ciudad de la dirección del remitente.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),     
        'provinceCode' => array(
            'title'       => __( 'Provincia', 'wc-packnow' ),
            'type'        => 'select',
            'description' => __( 'Seleccione el código de la Provincia. Este campo es de suma importancia, ya que se utilizará junto con el Código Postal para armar la ruta de la Orden de Retiro.', 'wc-packnow' ),
            'default'     => '',
            'options'     => array(
                ''   => __( 'Seleccione una provincia', 'wc-packnow' ),  
                '00'  => __( 'Ciudad Autónoma de Buenos Aires', 'wc-packnow' ),
                '01'  => __( 'Buenos Aires', 'wc-packnow' ),
                '02'  => __( 'Catamarca', 'wc-packnow' ),
                '03'  => __( 'Córdoba', 'wc-packnow' ),
                '04'  => __( 'Corrientes', 'wc-packnow' ),
                '05'  => __( 'Entre Ríos', 'wc-packnow' ),
                '06'  => __( 'Jujuy', 'wc-packnow' ),
                '07'  => __( 'Mendoza', 'wc-packnow' ),
                '08'  => __( 'La Rioja', 'wc-packnow' ),
                '09'  => __( 'Salta', 'wc-packnow' ),
                '10' => __( 'San Juan', 'wc-packnow' ),
                '11' => __( 'San Luis', 'wc-packnow' ),
                '12' => __( 'Santa Fe', 'wc-packnow' ),
                '13' => __( 'Santiago del Estero', 'wc-packnow' ),
                '14' => __( 'Tucumán', 'wc-packnow' ),
                '15' => __( 'Chaco', 'wc-packnow' ),
                '16' => __( 'Chubut', 'wc-packnow' ),
                '17' => __( 'Formosa', 'wc-packnow' ),
                '18' => __( 'Misiones', 'wc-packnow' ),
                '19' => __( 'Neuquén', 'wc-packnow' ),
                '20' => __( 'La Pampa', 'wc-packnow' ),
                '21' => __( 'Río Negro', 'wc-packnow' ),
                '22' => __( 'Santa Cruz', 'wc-packnow' ),
                '23' => __( 'Tierra del Fuego', 'wc-packnow' ),
            ),
        ),
        'streetname' => array(
          'title' 		=> __( 'Calle', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Nombre de la calle del domicilio remitente.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),                                   
        'streetNumber' => array(
          'title' 		=> __( 'Número de puerta de la dirección del remitente', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Número de puerta de la dirección del remitente. Este campo es de suma importancia, ya que se utilizará junto con el Código Postal y el nombre de la Calle para armar la ruta de la Orden de Retiro.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),    
        'floorNumber' => array(
          'title' 		=> __( 'Piso', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Número de piso de la dirección del remitente.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),             
        'department' => array(
          'title' 		=> __( 'Dpartamento', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Identificación del departamento de la dirección del remitente.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),             
        'betweenStreets' => array(
          'title' 		=> __( 'Entre Calles', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Se puede indicar las Entre Calles de la dirección del remitente como referencia.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),                                                       
        'postalcode' => array(
          'title' 		=> __( 'Código Postal del remitente', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Código Postal del remitente. Este campo es de suma importancia ya que con él se ruteará la Orden de Retiro.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),                                                       
        'observations' => array(
          'title' 		=> __( 'Observaciones', 'wc-packnow' ),
          'type' 			=> 'text',
          'description' 	=> __( 'Observaciones que desee incluirse en la Orden de Retiro.', 'wc-packnow' ),
          'default'		=> __( '', 'wc-packnow' )
        ),      
        
        'seguro' => array( 
          'title' 		=> __( 'Valor del SEGURO - Activar/Desactivar', 'wc-packnow' ),
          'type' 			=> 'checkbox',
          'label' 		=> __( 'Sumar el valor del seguro al total del envío ( trasladar el valor del seguro al cliente ).', 'wc-packnow' ),
          'default' 		=> 'yes'
        ),
        
        'withdrawDate' => array(
            'title'       => __( 'Fecha deseada de Retiro', 'wc-packnow' ),
            'type'        => 'select',
            'description' => __( 'Es la fecha deseada de Retiro de la mercadería. Al menos deben ser 48hs de realizada la Orden de Servicio.', 'wc-packnow' ),
            'default'     => '',
            'options'     => array(
                ''   => __( 'Seleccione una fecha', 'wc-packnow' ), 
                '1'  => __( '48hs', 'wc-packnow' ),
                '2'  => __( '72hs', 'wc-packnow' ),
                '3'  => __( '96hs', 'wc-packnow' ),
            ),
        ), 
 		    'withdrawInterval' => array(
            'title'       => __( 'Horario de Retiro', 'wc-packnow' ),
            'type'        => 'select',
            'description' => __( 'Se indica en qué horario se puede pasar a retirar la mercadería.', 'wc-packnow' ),
            'default'     => '3',
            'options'     => array(
                ''   => __( 'Seleccione un horario', 'wc-packnow' ), 
                '3'  => __( 'Todo el dia (9am a 6pm)', 'wc-packnow' ),
            ),
        ), 
  		  'rubroPaquetes' => array(
            'title'       => __( 'Rubros de paquetes', 'wc-packnow' ),
            'type'        => 'select',
            'description' => __( 'Se indica a qué rubro pertenece la mercadería.', 'wc-packnow' ),
            'default'     => '',
            'options'     => array(
                ''   => __( 'Seleccione un rubro', 'wc-packnow' ), 
                '1'  => __( 'Generico', 'wc-packnow' ),
                '2'  => __( 'Libros', 'wc-packnow' ),
                '3'  => __( 'Accesorios para Mascotas', 'wc-packnow' ),
                '4'  => __( 'Art.Librería', 'wc-packnow' ),
                '5'  => __( 'Bazar', 'wc-packnow' ),
                '6'  => __( 'Blanquería', 'wc-packnow' ),
                '7'  => __( 'Calzado', 'wc-packnow' ),
                '8'  => __( 'Cosmética', 'wc-packnow' ),
                '9'  => __( 'Perfumería', 'wc-packnow' ),
                '10'  => __( 'Ferretería', 'wc-packnow' ),
            ),
        ),        
      );
	  }
  
    public function calculate_shipping( $package = array() ) {
      $token = $this->get_token();
      if ( ! $token ) return;

      $destination_postcode = $package['destination']['postcode'];
        
      if ( empty( $destination_postcode ) || ! $this->is_valid_postcode( $destination_postcode ) ) return;

      $weight_unit = esc_attr(get_option('woocommerce_weight_unit'));
      $dimension_unit = esc_attr(get_option('woocommerce_dimension_unit'));

      $weight_multipliers_to_kg = [
          'kg' => 1,
          'g' => 0.001,
          'lbs' => 0.453592,
          'oz' => 0.0283495,
          'st' => 6.35029,
      ];
      $weight_multiplier = isset($weight_multipliers_to_kg[$weight_unit]) ? $weight_multipliers_to_kg[$weight_unit] : 1;
      $dimension_multiplier = ($dimension_unit == 'cm') ? 1 : ($dimension_unit == 'm' ? 100 : ($dimension_unit == 'in' ? 2.54 : ($dimension_unit == 'ft' ? 30.48 : 1)));

      // Helper to start a new package
      $new_package = function() {
          return [
              'weight' => 0,
              'depth' => 0,
              'width'  => 0,
              'height' => 0,
              'items'  => 0,
              'quantity'  => 0,
              'name'  => null,
          ];
      };

      $packages = [ $new_package() ];
      $seguro = null;
      foreach ( WC()->cart->get_cart() as $cart_item ) {
          $product = $cart_item['data'];
          $qty     = $cart_item['quantity'];
          $nombre = $cart_item['data']->get_name() ;
          $seguro += $cart_item['line_subtotal'];
       
          $len = (float) $product->get_length();
          $wid = (float) $product->get_width();
          $hei = (float) $product->get_height();
          $wei = (float) $product->get_weight();

          // Now $len, $wid, $hei, $wei are floats (or 0 if empty).
          // Then multiply safely:
          $len *= $dimension_multiplier;
          $wid *= $dimension_multiplier;
          $hei *= $dimension_multiplier;
          $wei *= $weight_multiplier;
        
          if( empty($len) || empty($wid) || empty($hei) || empty($wei) ){
            return;
          }
         
          if( $len > 50 || $wid > 80 || $hei > 80 || $wei > 32 ){
            return;
          }
 
          // For each unit of this product
          for ( $i = 0; $i < $qty; $i++ ) {
              // Try to fit in the last package
              $p = &$packages[ count($packages) - 1 ];
 
              $test_len   = max($p['depth'], $len);
              $test_wid   = max($p['width'],  $wid);
              $test_hei   = $p['height'] + $hei;
              $test_wei   = $p['weight'] + $wei;
 
              // Check limits
              if ($test_len > 50 || $test_wid > 80 || $test_hei > 80 || $test_wei > 32) {
                  // Start a new package if it doesn't fit
                  $packages[] = $new_package();
                  $p = &$packages[ count($packages) - 1 ];
                  $p['depth'] = $len; 
                  $p['width']  = $wid; 
                  $p['height'] = $hei; 
                  $p['weight'] = $wei; 
                  $p['items']  = 1;
                  $p['quantity'] = 1;

                  $p['name'][] = $nombre;
              } else {
                  $p['depth'] = $test_len;
                  $p['width']  = $test_wid;
                  $p['height'] = $test_hei;
                  $p['weight'] = $test_wei;
                  $p['items'] = 1;
                  $p['quantity']++;
                  $p['name'][] = $nombre;
              }
          }
      }

      $total_cost = 0;
      WC()->session->set('packnow_packages', $packages);
 
      
      $body = array(
        'packages' => $packages
      );
       
      $province_code = $package['destination']['state'];          // ej. "C"
      $states        = WC()->countries->get_states( 'AR' );
      $province_name = $states[ $province_code ] ?? '';

       /* slug sin espacios ni acentos */
      $province_slug = $province_name
        ? str_replace( ' ', '-', remove_accents( $province_name ) )
        : '';
      

      $base_url = 'https://api.packnow.com.ar/api/v1/quote/calculateMultiplePackagesCost/%s%s';
      $api_url  = sprintf(
          $base_url,
          urlencode( $destination_postcode ),
         $province_slug ? '/' . rawurlencode( $province_slug ) : ''
      );
      
      
      $body =  wp_json_encode( $body );
 
      $response = wp_remote_post( $api_url, [
        'headers' => [
            'Authorization' => 'Bearer ' . $token,
            'Content-Type'  => 'application/json',
        ],
        'body'    => $body  ,
        'timeout' => 45,
      ] );
      
      $body   = wp_remote_retrieve_body($response);
      $result = json_decode($body, true);
  
      if($this->seguro == 'yes'){
         
         foreach($result['packages'] as $paquetes){
 
           if($paquetes['assurancePercentage']){
             $porcentaje = $paquetes['assurancePercentage'];
           }
           
         }
        
         $total_seg = $seguro * $porcentaje;
         $total_seg = $total_seg / 100;         
         $total_cost = $result['totalSubtotal'] + $total_seg;
 
      }
 
      if($total_cost > 1){
        $rate = [
            'id'       => $this->get_rate_id(),
            'label'    => 'Packnow envío a domicilio',
            'cost'     => $total_cost,
            'calc_tax' => 'per_order',
        ];
        $this->add_rate($rate);        
      }


    }
  
 
    public function get_token() {
      $email    = $this->email;
      $password = $this->password;
 
      if ( empty( $email ) || empty( $password ) ) {
          return false;
      }

      // Check if token is already stored and not expired.
      $token        = get_transient( 'packnow_token_' . $this->instance_id );
      $token_expiry = get_option( 'packnow_token_expiry_' . $this->instance_id );
      
      if ( $token && $token_expiry && $token_expiry > time() ) {
          return $token;
      }

      // Prepare request data.
      $data = array(
          'email'    => $email,
          'password' => $password,
      );

      $response = wp_remote_post(
          'https://api.packnow.com.ar/api/v1/generic/webhook/auth',
          array(
              'method'  => 'POST',
              'headers' => array( 'Content-Type' => 'application/json' ),
              'body'    => wp_json_encode( $data ),
              'timeout' => 45,
          )
      );
 
      if ( is_wp_error( $response ) ) {
        
           update_option( 'packnow_user' , null );
          set_transient( 'packnow_token_' . $this->instance_id, null, null );
          update_option( 'packnow_token_expiry_' . $this->instance_id, null );
          return false;
      }

      $body   = wp_remote_retrieve_body( $response );
      $result = json_decode( $body, true );

      if ( isset( $result['data']['access_token'] ) ) {
          $token        = sanitize_text_field( $result['data']['access_token'] );
          $expires_in   = intval( $result['data']['expires_in'] );
          $token_expiry = time() + $expires_in;       
          $user_id        = sanitize_text_field( $result['data']['user']['id'] );
 
          update_option( 'packnow_user' , $user_id );
          set_transient( 'packnow_token_' . $this->instance_id, $token, $expires_in );
          update_option( 'packnow_token_expiry_' . $this->instance_id, $token_expiry );

          return $token;
      }

      return false;
  }
  
    private function is_valid_postcode( $postcode ) {
        // Remove any whitespace
        $postcode = trim( $postcode );
        // Check if it's exactly 4 digits
        if ( preg_match( '/^\d{4}$/', $postcode ) ) {
            return true;
        }
        return false;
    }
    
    private function is_request_for_cart_or_checkout() {
        if ( is_admin() ) {
            return false;
        }
        if ( function_exists( 'is_cart' ) && is_cart() ) {
            return true;
        }
        if ( function_exists( 'is_checkout' ) && is_checkout() ) {
            return true;
        }
        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            
            $actions = array( 'woocommerce_update_shipping_method', 'update_order_review', 'woocommerce_checkout', 'woocommerce_get_refreshed_fragments', 'update_shipping_method', 'checkout' );
            if ( isset( $_REQUEST['action'] ) && in_array( $_REQUEST['action'], $actions ) ) {
                return true;
            }
			      if ( isset( $_REQUEST['wc-ajax'] ) && in_array( $_REQUEST['wc-ajax'], $actions ) ) {
                return true;
            }			
			
			
			
        }
        return false;
    }

}
   