<?php
  use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;
  add_action('add_meta_boxes', 'add_packnow_metabox' );
  add_action('wp_ajax_packnow_get_etiqueta', 'packnow_get_etiqueta', 1); 
  add_action('wp_ajax_nopriv_packnow_get_etiqueta', 'packnow_get_etiqueta', 1); 
  add_action('wp_ajax_packnow_imponer', 'packnow_imponer', 1); 
  add_action('wp_ajax_nopriv_packnow_imponer', 'packnow_imponer', 1);	  
  add_action('wp_ajax_packnow_estado', 'packnow_estado', 1); 
  add_action('wp_ajax_nopriv_packnow_estado', 'packnow_estado', 1);	  
  add_action('woocommerce_checkout_create_order', 'save_packnow_packages_in_order', 10, 2);
  add_action('woocommerce_api_packnow', 'handle_packnow_webhook' );


  function add_packnow_metabox() {
    $screen = wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
      ? wc_get_page_screen_id( 'shop-order' )
      : 'shop_order';

    add_meta_box(
      'packnow',
      'Detalles PackNow',
      'render_packnow_metabox',
      $screen,
      'side',
      'high'
    );
  }
 
  function render_packnow_metabox( $post_or_order_object ) {
    global $post;
  
    $order = ( $post_or_order_object instanceof WP_Post ) ? wc_get_order( $post_or_order_object->ID ) : $post_or_order_object;
 
    $packnow_id = get_post_meta($post_or_order_object->ID, '_packnow_order_id', true); 
    $packnow_status = get_post_meta($post_or_order_object->ID, '_packnow_order_status', true); 
    $aesa_id = get_post_meta($post_or_order_object->ID, '_packnow_aesa_id', true); 
   
    $packnow_shipping_label_tracking = get_post_meta($post_or_order_object->ID, '_tracking_number', true);  
    $packnow_shipping_label_tracking_link = get_post_meta($post_or_order_object->ID, '_packnow_order_tracking', true); 
    $etiqueta_url = get_post_meta($post_or_order_object->ID, '_etiqueta_packnow', true);  
    $packnow_manual = get_post_meta( $post_or_order_object->ID, '_packnow_manual', true);
    
    $get_shipping_method = $order->get_shipping_method();
    
    if($get_shipping_method != 'Packnow envío a domicilio'){
      return;
    }

     
    $packages_json = $order->get_meta('_packnow_packages');


    if ($packages_json) {
        $packages_array = json_decode($packages_json, true);
        $cantidadp = count($packages_array);
        echo '<h3>PAQUETES: ' . $cantidadp . '</h3>';

        foreach ($packages_array as $key => $paquete) {
            $key += 1;
            echo '<h4>PAQUETE ' . $key . '</h4>';

            $names = isset( $paquete['name'] ) ? (array) $paquete['name'] : [];
            if ( ! $names ) {
              
            $names = isset( $paquete['names'] ) ? (array) $paquete['names'] : [];
              if ( ! $names ) {
              
                echo '<p>(sin datos de productos)</p>';
                continue;
              }
            }
            $product_counts = array_count_values( $names );

            foreach ($product_counts as $product_name => $quantity) {
                echo '<p>' . $product_name . ' x ' . $quantity . ' ' . ($quantity > 1 ? 'unidades' : 'unidad') . '</p>';
            }
        }
    }

  
    if( !empty($packnow_id) && empty($packnow_status)  ){
      echo  '<div style="position: relative; width: 100%; height: 60px;" >NRO. DE ORDEN PACKNOW:' . $packnow_id . '  </div>';
      
      if($aesa_id){
        echo  '<div style="position: relative; width: 100%; height: 60px;" >AESA ID:' . $aesa_id . '  </div>';
        echo '<a style=" width: 100%; text-align: center;  background: rgb(37, 56, 135);    color: white; padding: 10px; margin: 10px 0px;  text-decoration: none; box-sizing: border-box;" href="'. $packnow_shipping_label_tracking_link .'" target="_blank">TRACKING</a> ';   
       }
    
    ?>  

    <style type="text/css"> 
    #generar-packnow, #editar-packnow, #manual-packnow-generar, #obtener-a-packnow, #obtener-m-packnow  { 
      background: rgb(37, 56, 135);      color: white;      width: 100%;      text-align: center;      height: 40px;      padding: 0px;      line-height: 37px;      margin-top: 20px;      clear:both;    
    }
    #editar-packnow {   
      background: #d24040;  }  #manual-packnow {   display:none; 
    }   
  </style>  
    <img id="packnow_loader" style="display:none; width: 250px; height: auto; margin: 10px auto; position: relative;" src="<?php echo plugin_dir_url( __FILE__ ) . 'assets/img/logo-packnow.png'; ?>">  
    <div id="obtener-a-packnow" class="button" data-id="<?php echo $post_or_order_object->ID; ?>">OBTENER ESTADO</div> 
    <div class="packnow-single-label"></div>	 
    <script type="text/javascript"> 
      jQuery('body').on('click', '#obtener-a-packnow',function(e){    
        e.preventDefault();  
        var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";  
        var dataid = jQuery(this).data("id");  
        var metodo = jQuery(this).data("metodo");  
        jQuery(this).hide(); 
        jQuery('#packnow_loader').fadeIn();  
        jQuery.ajax({  
          type: 'POST', cache: false,  url: ajaxurl,  data: {
            action: 'packnow_estado',
            dataid: dataid,
          },  
          success: function(data, textStatus, XMLHttpRequest){  
            jQuery('#packnow_loader').fadeOut(); jQuery(".packnow-single-label").fadeIn(400);  jQuery(".packnow-single-label").html('');   jQuery(".packnow-single-label").append(data);  },  
          error: function(MLHttpRequest, textStatus, errorThrown){ }  
        });  
      });
    </script>
    <?php } 

 
    if(!empty($etiqueta_url)){ 
    echo  '<div style="position: relative; width: 100%; height: 60px;" >
    <a style=" width: 100%; text-align: center;  background: rgb(37, 56, 135);  float: left;  color: white; padding: 10px; margin: 10px 0px; text-decoration: none; box-sizing: border-box;" href="'. $etiqueta_url .'" target="_blank">Imprimir Etiqueta</a></div>';}  
  
    if (empty($packnow_id) ){ ?>  

      <style type="text/css"> 
      #generar-packnow, #editar-packnow, #manual-packnow-generar, #obtener-a-packnow, #obtener-m-packnow  { 
        background: rgb(37, 56, 135);      color: white;      width: 100%;      text-align: center;      height: 40px;      padding: 0px;      line-height: 37px;      margin-top: 20px;      clear:both;    
      }
      #editar-packnow {   
        background: #d24040;  }  #manual-packnow {   display:none; 
      }   
    </style>  
      <img id="packnow_loader" style="display:none; width: 250px; height: auto; margin: 10px auto; position: relative;" src="<?php echo plugin_dir_url( __FILE__ ) . 'assets/img/logo-packnow.png'; ?>">  
      <div id="obtener-a-packnow" class="button" data-id="<?php echo $post_or_order_object->ID; ?>">CARGAR ENVIO</div> 
      <div class="packnow-single-label"> 
      </div>	 
      <script type="text/javascript"> 
        jQuery('body').on('click', '#obtener-a-packnow',function(e){    
          e.preventDefault();  
          var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";  
          var dataid = jQuery(this).data("id");  
          var metodo = jQuery(this).data("metodo");  
          jQuery(this).hide(); 
          jQuery('#packnow_loader').fadeIn();  
          jQuery.ajax({  
            type: 'POST', cache: false,  url: ajaxurl,  data: {
              action: 'packnow_imponer',
              dataid: dataid,
            },  
            success: function(data, textStatus, XMLHttpRequest){  
              jQuery('#packnow_loader').fadeOut(); jQuery(".packnow-single-label").fadeIn(400);  jQuery(".packnow-single-label").html('');   jQuery(".packnow-single-label").append(data);  },  
            error: function(MLHttpRequest, textStatus, errorThrown){ }  
          });  
        });
      </script>
    <?php } 

}

 
  function handle_packnow_webhook() {

    $payload   = json_decode( file_get_contents( 'php://input' ), true );
    $log       = new WC_Logger();
    $log->add( 'packnow-WEBHOOKS', wp_json_encode( $payload ) );

    if ( empty( $payload['order_id'] ) ) {
      status_header( 400 );
      wp_die( 'Missing order_id' );
    }

    $packnow_id = sanitize_text_field( $payload['order_id'] );
    $status     = sanitize_text_field( $payload['status'] ?? '' );
    $link     = sanitize_text_field( $payload['link'] ?? '' );

    // Locate WooCommerce order by Packnow meta
    $orders = wc_get_orders( [
      'limit'      => 1,
      'meta_key'   => '_packnow_order_id',
      'meta_value' => $packnow_id,
    ] );

    if ( empty( $orders ) ) {
      status_header( 404 );
      wp_die( 'Order not found' );
    }

    $order = $orders[0];
    $order_id = $order->get_id();
    
    if ( $link ) {
      
      update_post_meta($order_id, '_etiqueta_packnow', $link);  
       
    }

    if ( 'paid' === $status ) {

      $shipping_methods = $order->get_items( 'shipping' );
      foreach ( $shipping_methods as $method ) {
        $instance_id  = $method->get_instance_id();
        $option_name  = 'woocommerce_wanderlust_packnow_' . $instance_id . '_settings';
        $settings     = get_option( $option_name, [] );
        if ( $settings ) {
          break;
        }
      }

      $token    = get_packnow_token( $settings['email'], $settings['password'], $instance_id );
      $api_url  = 'https://api.packnow.com.ar/api/v1/orders/' . $packnow_id;

      $response = wp_remote_get( $api_url, [
        'timeout' => 120,
        'headers' => [
          'Authorization' => 'Bearer ' . $token,
          'Content-Type'  => 'application/json',
        ],
      ] );

      $body = json_decode( wp_remote_retrieve_body( $response ), true );

      if ( 'Pedido retornado exitosamente' === ( $body['message'] ?? '' ) ) {

        $tracking = get_post_meta( $order_id, '_packnow_order_tracking', true );

        if ( empty( $tracking ) && ! empty( $body['data']['trackingCode'] ) ) {
          update_post_meta(
            $order_id,
            '_packnow_order_tracking',
            'https://app.packnow.com.ar/tracker-page?ref=landing&id=' . $body['data']['trackingCode']
          );
          update_post_meta(
            $order_id,
            '_packnow_aesa_id',
            $body['data']['shipment'][0]['aesa']['aesa_id']
          );
        }

        send_shipping_label(
          $body['data']['shipment'][0]['aesa']['aesa_id'],
          $settings['email']
        );
      }
    }

    status_header( 200 );
    wp_die( 'OK' );
  }



  function packnow_estado(){
    
    global $woocommerce, $post, $wp_session; 	
    $order_id  = $_POST['dataid']; 
    $order = wc_get_order($order_id);

    $packnow_user = get_option( 'packnow_user' , true );
 
    $packnow_id = get_post_meta($order_id, '_packnow_order_id', true); 
 
    $shipping_methods = $order->get_items('shipping');

    foreach ($shipping_methods as $method) {
      $instance_id = $method->get_instance_id();
      $option_name = 'woocommerce_wanderlust_packnow_' . $instance_id . '_settings';
      $shipping_method_settings = get_option($option_name, true);
      if ($shipping_method_settings) {
        continue;
      }
    }
 
    // Authenticate and get token
    $token = get_packnow_token($shipping_method_settings['email'], $shipping_method_settings['password'], $instance_id);
  
    if (!$token) {
        echo '<pre>ERROR TOKEN ';print_r($token);echo'</pre>';  
        return;
    }
 
    $payload = json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);

     // Send the request
    $api_url = 'https://api.packnow.com.ar/api/v1/orders/'.$packnow_id;

    $response = wp_remote_get( $api_url,
      array(
        'timeout'     => 120,
        'httpversion' => '1.1',
         'headers' => [
                        'Authorization' => 'Bearer ' . $token,
                        'Content-Type' => 'application/json',
                      ],     
      )
    );
 
     // Handle the response
    if (is_wp_error($response)) {
        echo '<pre>ERROR PEDIDO ';print_r($response);echo'</pre>';  
        return;
    }
 
    $response_body = json_decode(wp_remote_retrieve_body($response), true);
   
    if( $response_body['data']['payments'][0]['targetStateString'] == 'Pedido no pagado' ){
            echo '<a style=" width: 100%; text-align: center;  background: rgb(37, 56, 135);    color: white; padding: 10px; margin: 10px 0px;  text-decoration: none; box-sizing: border-box;" href="'. $response_body['data']['payments'][0]['url']  .'" target="_blank">ABONAR ENVIO</a>';   

    }
  
    if(  $response_body['message'] == 'Pedido retornado exitosamente' ){
       $tracking = get_post_meta($order_id, '_packnow_order_tracking', true);
      
      if(empty($tracking)){
        if($response_body['data']['trackingCode']){
          update_post_meta($order_id, '_packnow_order_tracking', 'https://app.packnow.com.ar/tracker-page?ref=landing&id='. $response_body['data']['trackingCode'] );
          update_post_meta($order_id, '_packnow_aesa_id',  $response_body['data']['shipment'][0]['aesa']['aesa_id']);

          echo '<a style=" width: 100%; text-align: center;  background: rgb(37, 56, 135);    color: white; padding: 10px; margin: 10px 0px;   text-decoration: none; box-sizing: border-box;" href="https://app.packnow.com.ar/tracker-page?ref=landing&id='. $response_body['data']['trackingCode']  .'" target="_blank">TRACKING</a>';   
        }    
        
        
            
      }
      
      send_shipping_label($response_body['data']['shipment'][0]['aesa']['aesa_id'], $shipping_method_settings['email']);       
 

 
    }  
       die();
  }
 
  function packnow_imponer() { 
    global $woocommerce, $post, $wp_session; 	
    $order_id  = $_POST['dataid']; 
    $order = wc_get_order($order_id);

    $packnow_user = get_option( 'packnow_user' , true );
 
    $shipping_methods = $order->get_items('shipping');

    foreach ($shipping_methods as $method) {
      $instance_id = $method->get_instance_id();
      $option_name = 'woocommerce_wanderlust_packnow_' . $instance_id . '_settings';
      $shipping_method_settings = get_option($option_name, true);
      if ($shipping_method_settings) {
        continue;
      }
    }
     
    // Ensure the required settings are available
    if (empty($shipping_method_settings['email']) || empty($shipping_method_settings['password'])) {
      error_log('PackNow settings are missing required fields.');
      return;
    }

  
    $withdraw_date_map = [
        '1' => 48,  // 48 hours
        '2' => 72,  // 72 hours
        '3' => 96,  // 96 hours
    ];
  
  
    $selected_withdraw_option = isset($shipping_method_settings['withdrawDate']) ? $shipping_method_settings['withdrawDate'] : '1';
    $selected_hours = isset($withdraw_date_map[$selected_withdraw_option]) ? $withdraw_date_map[$selected_withdraw_option] : 48;

    // Calculate withdrawDate as today + selected hours
    $withdraw_date = (new DateTime())->add(new DateInterval('PT' . $selected_hours . 'H'))->format('d/m/Y');
    
    
      foreach ($order->get_items() as $item_id => $item) {
        $product = $item->get_product();
        if (!$product) continue;

        

        $quantity       = $item->get_quantity();
        $item_subtotal  += $item->get_total(); // Price for this line
        $unit_price     = ($quantity > 0) ? ($item_subtotal / $quantity) : $item_subtotal;
        
      }
   
     // Extract origin info from plugin settings
    $origin_info = [
        "email" => $shipping_method_settings['email'],
        "phone" => $shipping_method_settings['telefono'],
        "lastName" => $shipping_method_settings['lastname'],
        "location" => $shipping_method_settings['location'],
        "firstName" => $shipping_method_settings['firstname'],
        "department" => $shipping_method_settings['department'],
        "postalCode" => $shipping_method_settings['postalcode'],
        "streetName" => $shipping_method_settings['streetname'],
        "fantasyName" => $shipping_method_settings['fantasyName'],
        "floorNumber" => $shipping_method_settings['floorNumber'],
        "observations" => $shipping_method_settings['observations'],
        "provinceCode" => $shipping_method_settings['provinceCode'],
        "streetNumber" => $shipping_method_settings['streetNumber'],
        "withdrawDate" => $withdraw_date,
        "betweenStreets" => $shipping_method_settings['betweenStreets'],
        "withdrawInterval" => (int)$shipping_method_settings['withdrawInterval'],
    ];
  
    // Authenticate and get token
    $token = get_packnow_token($shipping_method_settings['email'], $shipping_method_settings['password'], $instance_id);
  
    if (!$token) {
        error_log('PackNow: Failed to retrieve API token.');
        return;
    }
  
  
    $package = build_package_from_order_items($order_id, $shipping_method_settings['rubroPaquetes']);
   
    $woocommerce_state = $order->get_shipping_state();  
    $province_code = get_packnow_province_code($woocommerce_state);
    
    
    $idpedido = get_post_meta( $order_id, '_order_number', true);
    if($idpedido){
      $idpedido = '(WC-' . $idpedido .') - ';
    } else {
      $idpedido = '(WC-' . $order_id .') - ';
    }
    
    
    $notas = $idpedido;
    $notas .= $order->get_customer_note();
    
    $altura = $order->get_shipping_address_2();
    $site_url = get_site_url();
    $notificaciones = $site_url . "/?wc-api=packnow";
     
       
     
    $payload = [
    "id" => $packnow_user,
    "quote" => [
        "app" => 3,
        "origin" => $origin_info,
        "shipments" => [
            [
                "total" => (int)$order->get_shipping_total(),  // TOTAL ENVIO
                "valid" => true,
                "destiny" => [
                    "email" => $order->get_billing_email(),
                    "phone" => $order->get_billing_phone(),
                    "lastName" => $order->get_shipping_last_name(),
                    "firstName" => $order->get_shipping_first_name(),
                    "location" => $order->get_shipping_city(),
                    "postalCode" => $order->get_shipping_postcode(),
                    "streetName" => $order->get_shipping_address_1(),
                    "streetNumber" => $altura,
                    "provinceCode" => $province_code,
                    "department" =>  "",
                    "floorNumber"  => "",
                    "deliveryDate" => "",
                    "observations" => $notas,
                    "betweenStreets" => "",
                    "deliveryInterval" => null
                ],
                "packages" => $package 
            ]
        ],
        "aditionals" => [
            "tags" => [
                "tagsPrice" => 0,
                "wantsTags" => false,
                "tagsFormat" => 2
            ],
            "assurance" => [
                "assuranceCost" => 0,
                "declaredAmount" => $item_subtotal,
                "wantsLoadAssurance" => true
            ]
        ]
    ],
    "total" => (int)$order->get_shipping_total(),
    "notification_url" => $notificaciones
  ];

    $payload = json_encode($payload, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
 
      
    // Send the request
    $api_url = 'https://api.packnow.com.ar/api/v1/generic/webhook';
 
    $response = wp_remote_post( $api_url, array(
                    'method'      => 'POST',
                    'timeout'     => 25,
                    'redirection' => 5,
                    'httpversion' => '1.1',
                    'blocking'    => true,
                    'headers' => [
                      'Authorization' => 'Bearer ' . $token,
                      'Content-Type' => 'application/json',
                    ],                   
                    'body' => $payload,
                    'cookies'     => array()
                    )
    );
    // Handle the response
    if (is_wp_error($response)) {
        echo '<pre>$payload ';print_r($payload);echo'</pre>';  
        echo '<pre>$response ';print_r($response);echo'</pre>';  
        return;
    }
 
    $response_body = json_decode(wp_remote_retrieve_body($response), true);
    
    if($response_body['error']){
      echo '<pre>$payload ';print_r($payload);echo'</pre>';  
      echo '<pre>$response ';print_r($response);echo'</pre>';  
      return;
    }
  
   
    if (!empty($response_body['order_id'])) {
        update_post_meta($order_id, '_packnow_order_id', $response_body['order_id']);
        update_post_meta($order_id, 'packnow_envia', $payload);
        echo 'NRO. DE ORDEN PACKNOW:  '.$response_body['order_id'];
         die();
    } else {
        error_log('PackNow API response error: ' . wp_remote_retrieve_body($response));
    }
  }
 
  function send_shipping_label($order_id, $email) {
      
      $params = array(
        "method" => array(
          "get_etiqueta" => array(
            "identrega" => $order_id,
            "email" => $email
          )
        )
      );

      $ch = curl_init();
      curl_setopt_array($ch, array(
        CURLOPT_TIMEOUT => 45,
        CURLOPT_POST => TRUE,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_POSTFIELDS => http_build_query($params),
        CURLOPT_URL => "https://wanderlust.codes/packnow/etiqueta.php",
        CURLOPT_RETURNTRANSFER => TRUE,
        CURLOPT_FOLLOWLOCATION => TRUE
      ));
      $response = curl_exec($ch);
      curl_close($ch);

     
   

    return true;
}
 
  function get_packnow_token($email, $password, $instance_id) {
       
      if ( empty( $email ) || empty( $password ) ) {
          return false;
      }

      // Check if token is already stored and not expired.
      $token        = get_transient( 'packnow_token_' . $instance_id );
      $token_expiry = get_option( 'packnow_token_expiry_' . $instance_id );
      
 

      // Prepare request data.
      $data = array(
          'email'    => $email,
          'password' => $password,
      );

      $response = wp_remote_post(
          'https://api.packnow.com.ar/api/v1/generic/webhook/auth',
          array(
              'method'  => 'POST',
              'headers' => array( 'Content-Type' => 'application/json' ),
              'body'    => wp_json_encode( $data ),
              'timeout' => 45,
          )
      );
 
      if ( is_wp_error( $response ) ) {
        
         update_option( 'packnow_user' , null );
          set_transient( 'packnow_token_' . $instance_id, null, null );
          update_option( 'packnow_token_expiry_' . $instance_id, null );
          return false;
      }

      $body   = wp_remote_retrieve_body( $response );
      $result = json_decode( $body, true );

      if ( isset( $result['data']['access_token'] ) ) {
          $token        = sanitize_text_field( $result['data']['access_token'] );
          $expires_in   = intval( $result['data']['expires_in'] );
          $user_id        = sanitize_text_field( $result['data']['user']['id'] );

          $token_expiry = time() + $expires_in;

          // Store token and expiry.
          update_option( 'packnow_user' , $user_id );
          set_transient( 'packnow_token_' . $instance_id, $token, $expires_in );
          update_option( 'packnow_token_expiry_' . $instance_id, $token_expiry );

          return $token;
      }

      return false;
  }

  function get_packnow_province_code($woocommerce_state) {
    // Define the mapping of WooCommerce state IDs (single letters) to PackNow numeric province codes
    $province_mapping = [
        'C' => '00',  // Ciudad Autónoma de Buenos Aires
        'B' => '01',  // Buenos Aires
        'K' => '02',  // Catamarca
        'X' => '03',  // Córdoba
        'W' => '04',  // Corrientes
        'E' => '05',  // Entre Ríos
        'Y' => '06',  // Jujuy
        'M' => '07',  // Mendoza
        'F' => '08',  // La Rioja
        'A' => '09',  // Salta
        'J' => '10', // San Juan
        'D' => '11', // San Luis
        'S' => '12', // Santa Fe
        'G' => '13', // Santiago del Estero
        'T' => '14', // Tucumán
        'H' => '16', // Chaco
        'U' => '17', // Chubut
        'P' => '18', // Formosa
        'N' => '19', // Misiones
        'Q' => '20', // Neuquén
        'L' => '21', // La Pampa
        'R' => '22', // Río Negro
        'Z' => '23', // Santa Cruz
        'V' => '24', // Tierra del Fuego
    ];

    // Return the matching province code or null if not found
    return isset($province_mapping[$woocommerce_state]) ? $province_mapping[$woocommerce_state] : null;
}
 
  function build_package_from_order_items($order_id, $rubro) {
    $order = wc_get_order($order_id);
    if (!$order) {
        return false;
    }

    $weight_unit    = esc_attr(get_option('woocommerce_weight_unit'));
    $dimension_unit = esc_attr(get_option('woocommerce_dimension_unit'));

    $weight_multipliers_to_kg = [
        'kg'  => 1,
        'g'   => 0.001,
        'lbs' => 0.453592,
        'oz'  => 0.0283495,
    ];
    $dimension_multipliers_to_cm = [
        'cm'  => 1,
        'm'   => 100,
        'in'  => 2.54,
        'ft'  => 30.48,
    ];

    $weight_multiplier    = $weight_multipliers_to_kg[$weight_unit]     ?? 1;
    $dimension_multiplier = $dimension_multipliers_to_cm[$dimension_unit] ?? 1;

    // Helper to create a fresh package structure
    $new_package = function($rubro) {
        return [
            'valid'           => true,
            'depth'           => 0,
            'width'           => 0,
            'height'          => 0,
            'weight'          => 0,
            'quantity'        => 0,
            'subtotal'        => 0,
            'unitPrice'       => 0,
            'overWeight'      => false,
            'description'     => 'Paquete Woocommerce',
            'packageWeight'   => 0,
            'declaredAmount'  => 0,
            'package_type_id' => $rubro,
        ];
    };

    $packages = [$new_package($rubro)];

    // Loop through each line item
    foreach ($order->get_items() as $item) {
        $product = $item->get_product();
        if (!$product) {
            continue;
        }

        // Dimensions/weight
        $length = round($product->get_length() * $dimension_multiplier, 2);
        $width  = round($product->get_width()  * $dimension_multiplier, 2);
        $height = round($product->get_height() * $dimension_multiplier, 2);
        $weight = round($product->get_weight() * $weight_multiplier, 2);

        $quantity    = $item->get_quantity();
        $line_total  = (float) $item->get_total(); // total price for that line
        $unit_price  = ($quantity > 0) ? $line_total / $quantity : $line_total;

        // Place each item (quantity) into a package
        for ($i = 0; $i < $quantity; $i++) {
            $p = &$packages[count($packages) - 1];

            $test_length   = max($p['depth'], $length);
            $test_width    = max($p['width'], $width);
            $test_height   = $p['height'] + $height;
            $test_weight   = $p['weight'] + $weight;

            // If the item doesn't fit, create a new package
            if (
                $test_length > 50 ||
                $test_width  > 80 ||
                $test_height > 80 ||
                $test_weight > 32
            ) {
                $packages[] = $new_package($rubro);
                $p = &$packages[count($packages) - 1];

                $p['depth']          = $length;
                $p['width']          = $width;
                $p['height']         = $height;
                $p['weight']         = $weight;
                $p['quantity']       = 1;
                $p['subtotal']       = $unit_price;
                $p['unitPrice']      = $unit_price;
                $p['packageWeight']  = $weight;
                $p['declaredAmount'] = $unit_price;
                $p['overWeight']     = $weight > 20;
            } else {
                $p['depth']          = $test_length;
                $p['width']          = $test_width;
                $p['height']         = $test_height;
                $p['weight']         = $test_weight;
                $p['quantity']       = 1;
                $p['subtotal']      += $unit_price;
                $p['unitPrice']      = $unit_price;
                $p['packageWeight']  = $test_weight;
                $p['declaredAmount'] = $p['subtotal'];
                $p['overWeight']     = $test_weight > 20;
            }
        }
    }

    if (empty($packages)) {
        return false;
    }

    return $packages;
}

  function save_packnow_packages_in_order( $order, $data ) {
    // Retrieve what we stored in the session
    $packnow_packages = WC()->session->get('packnow_packages');

    // If we have packages, store them as JSON or serialized array
    if ( ! empty( $packnow_packages ) ) {
        // Example: store JSON in the order meta
        $order->update_meta_data('_packnow_packages', wp_json_encode($packnow_packages));
    }
}



 
?>