<?php
/**
 * Plugin Name: Wanderlust Packnow
 * Plugin URI: https://www.packnow.com.ar/
 * Description: Plugin que conecta la API de Packnow con WooCommerce.
 * Author: Wanderlust Codes
 * Author URI: https://wanderlust-webdesign.com/
 * Version: 1.0.2
 * Text Domain: wc-packnow
 * Domain Path: /i18n/languages/
 * Copyright: (c) 2010-2025 Wanderlust Web Design
 * Requires Plugins: woocommerce
 * Tested up to: 6.7.1
 * WC tested up to: 9.4.2
 * WC requires at least: 4.0
 *
 * @package   WC-Packnow
 * @author    Wanderlust Web Design
 * @category  Admin
 * @copyright Copyright (c) 2010-2025, Wanderlust Web Design
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}


  add_action( 'before_woocommerce_init', function() {
 	        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
 	                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
 	        }
 	} );
  add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'woocommerce_packnow_plugin_links' );
  add_action( 'woocommerce_shipping_init', 'wanderlust_packnow_init' );
  add_filter( 'woocommerce_shipping_methods', 'wanderlust_packnow_add_method' );

  require_once( 'includes/functions.php' );  

  function woocommerce_packnow_plugin_links( $links ) { 
    $plugin_links = array( '<a href="http://#">' . __( 'Soporte', 'woocommerce-shipping-epick' ) . '</a>', ); 
    return array_merge( $plugin_links, $links );
  }
 
  /**
   * Initialize the shipping method.
   */
  function wanderlust_packnow_init() {
      if ( ! class_exists( 'WC_Shipping_Method' ) ) {
          return;
      }

      // Include the shipping method class.
      include_once 'includes/class-wc-shipping-packnow.php';
  }
 
  /**
   * Add the shipping method to WooCommerce.
   *
   * @param array $methods Existing shipping methods.
   * @return array Modified shipping methods.
   */
  function wanderlust_packnow_add_method( $methods ) {
      $methods['wanderlust_packnow'] = 'WC_Shipping_Wanderlust_Packnow';
      return $methods;
  }
  